unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Menus, ExtCtrls;

type
  TForm1 = class(TForm)
    Label1: TLabel;
    ComboBox1: TComboBox;
    ComboBox2: TComboBox;
    ScrollBar1: TScrollBar;
    Edit_Jahr: TEdit;
    Ende: TButton;
    Edit_wochentag: TEdit;
    Edit_schalt: TEdit;
    Rechnen: TButton;
    Clear: TButton;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Panel1: TPanel;
    Label6: TLabel;
    procedure ScrollBar1Change(Sender: TObject);
    procedure EndeClick(Sender: TObject);
    procedure Edit_JahrChange(Sender: TObject);
    procedure ClearClick(Sender: TObject);
    procedure init(Sender: TObject);
    procedure RechnenClick(Sender: TObject);
    procedure Change(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.ScrollBar1Change(Sender: TObject);
begin
  Edit_Jahr.Text:=FloatToStr(Scrollbar1.Position);
  Edit_schalt.Visible:=false;
  Edit_wochentag.Visible:=false;
  Label6.Visible:=false;
end;

procedure TForm1.EndeClick(Sender: TObject);
begin
close;
end;

procedure TForm1.Edit_JahrChange(Sender: TObject);
var j:integer;

begin
    Edit_schalt.Visible:=false;
    Edit_wochentag.Visible:=false;
    Label6.Visible:=false;
    if edit_jahr.text<>'' then
    j:=strtoint(Edit_jahr.Text) ;
    if (j>=1600) and (j<=2400)
    then
    begin
      Scrollbar1.position:=strtoint(Edit_Jahr.Text);
      panel1.Visible:=false;
    end
    else
     begin
      panel1.Caption:='Bitte Jahreszahl zw. 1600 und 2400 eingeben!';
      panel1.Visible:=true;
     end;
end;

procedure TForm1.ClearClick(Sender: TObject);
var  Present: TDateTime;
     Year, Month, Day : word;
begin
  Present:= Now;
  DecodeDate(Present, Year, Month, Day);
  Combobox2.ItemIndex:=day-1;
  Combobox1.ItemIndex:=month-1;
  Edit_jahr.Text:=inttostr(year);
  Scrollbar1.Position:=year;
  Edit_Wochentag.Visible:=false;
  Edit_Schalt.Visible:=false;
  panel1.Visible:=false;
  Rechnen.Visible:=true;
  Label6.Visible:=false;
end;

procedure TForm1.init(Sender: TObject);
var  Present: TDateTime;
     Year, Month, Day : word;
begin
  Present:= Now;
  DecodeDate(Present, Year, Month, Day);
  Combobox2.ItemIndex:=day-1;
  Combobox1.ItemIndex:=month-1;
  Scrollbar1.Position:=year;
end;

procedure TForm1.RechnenClick(Sender: TObject);
var tag,monat,jahr,sj,k,j,c,d:integer;
    wotag:Ansistring;
begin
  tag:=Combobox2.ItemIndex+1;
  monat:=Combobox1.Itemindex+1;
  jahr:=Scrollbar1.Position;
  sj:=0;d:=0;
  if jahr mod 400=0 then sj:=1;
  if (jahr mod 4=0 ) and (jahr mod 100<>0)then sj:=1;
  if ((monat=4) or (monat=6) or (monat=9)or(monat=11)) and (tag>30)then d:=1;
  if (monat=2) and (tag>28+sj) then d:=1;
  if d=1 then
   begin
    Panel1.Caption:='Das Datum ist nicht gltig';
    Panel1.Visible:=true;
    Rechnen.Visible:=false;
   end
   else
    begin
     case (monat) of
      1   : k:=6-sj;
      2   : k:=2-sj;
      3,11: k:=2;
      4,7 : k:=5;
      5   : k:=0;
      6   : k:=3;
      8   : k:=1;
      9,12: k:=4;
      10  : k:=6;
     end;
     j:=jahr mod 100;
     c:=jahr div 100;
     d:=tag+k+j+j div 4- 2*(c mod 4);
     d:=d mod 7;
     case (d) of
      0 : wotag:='Sonntag';
      1 : wotag:='Montag';
      2 : wotag:='Dienstag';
      3 : wotag:='Mittwoch';
      4 : wotag:='Donnerstag';
      5 : wotag:='Freitag';
      6 : wotag:='Sonnabend';
      end;
      if sj=1 then Edit_schalt.Text:='Das war ein Schaltjahr'
              else Edit_schalt.Text:='Das war kein Schaltjahr';
      Edit_schalt.Visible:=true;
      Edit_Wochentag.Text:=wotag;
      Label6.Visible:=true;
      Edit_Wochentag.Visible:=true;
      
    end;
end;

procedure TForm1.Change(Sender: TObject);
begin
 Edit_Schalt.Visible:=false;
 Edit_wochentag.Visible:=false;
 Label6.Visible:=false;
end;

end.


