//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "Unit1.h"
#include <math.h>
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TWurfaufgabe *Wurfaufgabe;
double g=9.807;
//---------------------------------------------------------------------------
__fastcall TWurfaufgabe::TWurfaufgabe(TComponent* Owner)
        : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TWurfaufgabe::EndeClick(TObject *Sender)
{
Close();        
}
//---------------------------------------------------------------------------

void __fastcall TWurfaufgabe::Rechnen1Click(TObject *Sender)
{ double v,s,t;
  s=E_h1->Text.ToDouble();
  t=sqrt(2*s/g);
  v=g*t;
  E_t1->Text=FloatToStrF(t,ffFixed,10,3)+" s";
  E_v11->Text=FloatToStrF(v,ffFixed,10,3)+" m/s";
  E_v12->Text=FloatToStrF(v*3.6,ffFixed,10,3)+" km/h";
}
//---------------------------------------------------------------------------

void __fastcall TWurfaufgabe::Erase1Click(TObject *Sender)
{
E_t1->Text=" ";
E_h1->Text=FloatToStr(0);
E_v11->Text=" ";
E_v12->Text=" ";
}
//---------------------------------------------------------------------------




void __fastcall TWurfaufgabe::Rechnen2Click(TObject *Sender)
{ double v0,v,h,s,t,t1,t2;
  s=E_h20->Text.ToDouble();
  v0=E_v20->Text.ToDouble();
  t1=v0/g;            // Steigzeit
  h=v0*v0/(2*g);      // Steighhe
  E_t21->Text=FloatToStrF(t1,ffFixed,10,3)+" s";
  E_h21->Text=FloatToStrF(h,ffFixed,10,3)+" m";
  h=h+s;
  t2=sqrt(2*h/g);
  v=g*t2;
  t=t1+t2;
  E_t22->Text=FloatToStrF(t,ffFixed,10,3)+" s";
  E_v21->Text=FloatToStrF(v,ffFixed,10,3)+" m/s";
  E_v22->Text=FloatToStrF(v*3.6,ffFixed,10,3)+" km/h";

}
//---------------------------------------------------------------------------

void __fastcall TWurfaufgabe::Erase2Click(TObject *Sender)
{

E_h20->Text=FloatToStr(0);
E_v20->Text=FloatToStr(0);
E_t21->Text=" ";
E_t22->Text=" ";
E_h21->Text=" ";
E_v21->Text=" ";
E_v22->Text=" ";

}
//---------------------------------------------------------------------------

void __fastcall TWurfaufgabe::Rechnen3Click(TObject *Sender)
{
  double v0,v,s,t;
  s=E_h3->Text.ToDouble();
  v0=E_v30->Text.ToDouble();
  t=(sqrt(v0*v0+2*g*s)-v0)/g;
  v=v0+g*t;
  E_t3->Text=FloatToStrF(t,ffFixed,10,3)+" s";
  E_v31->Text=FloatToStrF(v,ffFixed,10,3)+" m/s";
  E_v32->Text=FloatToStrF(v*3.6,ffFixed,10,3)+" km/h";

}
//---------------------------------------------------------------------------

void __fastcall TWurfaufgabe::Erase3Click(TObject *Sender)
{
E_h3->Text=FloatToStr(0);
E_v30->Text=FloatToStr(0);
E_t3->Text=" ";
E_v31->Text=" ";
E_v32->Text=" ";
}
//---------------------------------------------------------------------------

void __fastcall TWurfaufgabe::Rechnen4Click(TObject *Sender)
{ double v,v0,s,w,t;
  s=E_h4->Text.ToDouble();
  v0=E_v40->Text.ToDouble();
  t=sqrt(2*s/g);
  w=v0*t;
  v=sqrt(v0*v0+g*t*g*t);
  E_w4->Text=FloatToStrF(w,ffFixed,10,3)+" m";
  E_t4->Text=FloatToStrF(t,ffFixed,10,3)+" s";
  E_v41->Text=FloatToStrF(v,ffFixed,10,3)+" m/s";
  E_v42->Text=FloatToStrF(v*3.6,ffFixed,10,3)+" km/h";

}
//---------------------------------------------------------------------------

void __fastcall TWurfaufgabe::Erase4Click(TObject *Sender)
{
E_h4->Text=FloatToStr(0);
E_v40->Text=FloatToStr(0);
E_t4->Text=" ";
E_w4->Text=" ";
E_v41->Text=" ";
E_v42->Text=" ";
}
//---------------------------------------------------------------------------



void __fastcall TWurfaufgabe::Rechnen5Click(TObject *Sender)
{ double v0,v,h,s,t,t1,t2,alpha,w;
  s=E_h50->Text.ToDouble();
  v0=E_v50->Text.ToDouble();
  alpha=E_wi50->Text.ToDouble()*M_PI/180.0;
  t1=v0*sin(alpha)/g;                    // Steigzeit
  h=v0*v0*sin(alpha)*sin(alpha)/(2*g);   // Steighhe
  E_t51->Text=FloatToStrF(t1,ffFixed,10,3)+" s";
  E_h51->Text=FloatToStrF(h,ffFixed,10,3)+" m";
  h=h+s;
  t2=sqrt(2*h/g);
  t=t1+t2;
  v=sqrt(v0*v0*cos(alpha)*cos(alpha)+g*h);
  w=v0*t*cos(alpha);
  E_w5->Text=FloatToStrF(w,ffFixed,10,3)+" m";
  E_t52->Text=FloatToStrF(t,ffFixed,10,3)+" s";
  E_v51->Text=FloatToStrF(v,ffFixed,10,3)+" m/s";
  E_v52->Text=FloatToStrF(v*3.6,ffFixed,10,3)+" km/h";
        
}
//---------------------------------------------------------------------------

void __fastcall TWurfaufgabe::Erase5Click(TObject *Sender)
{
E_h50->Text=FloatToStr(0);
E_v50->Text=FloatToStr(0);
E_wi50->Text=FloatToStr(45);
E_h51->Text=" ";
E_t51->Text=" ";
E_t52->Text=" ";
E_w5->Text=" ";
E_v51->Text=" ";
E_v52->Text=" ";

}
//---------------------------------------------------------------------------

void __fastcall TWurfaufgabe::Rechnen6Click(TObject *Sender)
{ double v0,v,vx,vy,s,t,t1,t2,alpha,w;
  s=E_h6->Text.ToDouble();
  v0=E_v60->Text.ToDouble();
  alpha=E_wi6->Text.ToDouble()*M_PI/180.0;
  vx=v0*cos(alpha);
  vy=v0*sin(alpha);
  t=(sqrt(vy*vy+2*g*s)-vy)/g;
  w=vx*t;
  vy=vy+g*t;
  v=sqrt(vx*vx+vy*vy);
  E_w6->Text=FloatToStrF(w,ffFixed,10,3)+" m";
  E_t6->Text=FloatToStrF(t,ffFixed,10,3)+" s";
  E_v61->Text=FloatToStrF(v,ffFixed,10,3)+" m/s";
  E_v62->Text=FloatToStrF(v*3.6,ffFixed,10,3)+" km/h";

}
//---------------------------------------------------------------------------

void __fastcall TWurfaufgabe::Erase6Click(TObject *Sender)
{
E_h6->Text=FloatToStr(0);
E_v60->Text=FloatToStr(0);
E_wi6->Text=FloatToStr(45);
E_t6->Text=" ";
E_w6->Text=" ";
E_v61->Text=" ";
E_v62->Text=" ";

}
//---------------------------------------------------------------------------

